package cn.com.duiba.kjy.api.enums.pageVersion;

/**
 * 页面版本类型枚举
 * @author 吴文哲
 * @date 2020-04-24 15:04
 **/
public enum PageVersionTabEnum {

    INDEX(1,"首页")
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    public static PageVersionTabEnum getByType(Integer type) {
        for (PageVersionTabEnum enumVal : PageVersionTabEnum.values()) {
            if (enumVal.getType().equals(type)) {
                return enumVal;
            }
        }
        return null;
    }

    PageVersionTabEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;

    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
