package cn.com.duiba.kjy.api.enums.presentInsurance;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 赠险分类枚举
 * @author xiaotian
 * @date 2020/8/10 3:43 PM
 */
public enum PresentInsuranceEnum {

    /**
     * 人身意外险
     */
    ACCIDENT(1, "人身意外险","意外型赠险","人身意外保障","https://yun.duiba.com.cn/kjy/media/image/20200822/8378fa00b013ef919b01703d0e7fa71e.png?x-oss-process=image/quality,q_80","%s元保额 [人身安全意外险]","意外伤害事故保障","意外事故有保障","意外险免费保额%s"),
    /**
     * 重疾型赠险
     */
    CRITICAL_ILLNESS(2,"重疾险","重疾型赠险","大病保障重疾险","https://yun.duiba.com.cn/kjy/media/image/20200822/ebfdcc5045b8b479a0c8b6ba17c76f01.png?x-oss-process=image/quality,q_80","%s元保额 [大病无忧重疾险]","得了大病也不怕","重大疾病不犯愁","重疾险免费保额%s"),
    /**
     * 疫情型赠险
     */
    EPIDEMIC(3,"疫情险","疫情型赠险","新冠肺炎疫情险","https://yun.duiba.com.cn/kjy/media/image/20200822/d0cd4102309257d0665d36231e382e0e.png?x-oss-process=image/quality,q_80","%s元保额 [新冠肺炎疫情险]","疫情之下，人人必备","共同防护新冠肺炎","疫情险免费保额%s"),
    /**
     * 医疗型赠险
     */
    MEDICAL_INSURANCE(4,"医疗险","医疗型赠险","健康无忧医疗险","https://yun.duiba.com.cn/kjy/media/image/20200822/86d9c9f1322ed1188080fcf841b7bc2c.png?x-oss-process=image/quality,q_80","%s元保额 [健康无忧医疗险]","免费报销看病费用","看病不再花钱","医疗险免费保额%s")
    ;

    private Integer code;
    /**
     * 枚举描述
     */
    private String desc;
    /**
     * 推送描述
     */
    private String pushDesc;
    /**
     * 默认标题
     */
    private String title;
    /**
     * 图片
     */
    private String image;
    /**
     * 线索详情页文案
     */
    private String clueSummary;

    /**
     * 描述文案
     */
    private String content;
    /**
     * 个人专栏title
     */
    private String columnTitle;

    /**
     * 专栏文案
     */
    private String columnContent;


    PresentInsuranceEnum(Integer code, String desc, String pushDesc, String title, String image, String clueSummary,String content,String columnTitle,String columnContent) {
        this.code = code;
        this.desc = desc;
        this.pushDesc = pushDesc;
        this.title = title;
        this.image = image;
        this.clueSummary = clueSummary;
        this.content = content;
        this.columnContent = columnContent;
        this.columnTitle = columnTitle;
    }

    public String getContent() {
        return content;
    }

    public String getImage() {
        return image;
    }

    public String getClueSummary() {
        return clueSummary;
    }

    public String getTitle() {
        return title;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getPushDesc() {
        return pushDesc;
    }

    public String getColumnContent() {
        return columnContent;
    }

    public String getColumnTitle() {
        return columnTitle;
    }

    private static final Map<Integer, PresentInsuranceEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PresentInsuranceEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    /**
     * 手机端展示的赠险模版和顺序（V1）
     * @return
     */
    public static List<PresentInsuranceEnum> getShowInsuranceV1(){
        return Arrays.asList(ACCIDENT,EPIDEMIC,CRITICAL_ILLNESS);
    }

    /**
     * 手机端展示的赠险模版和顺序（V2）
     * @return
     */
    public static List<PresentInsuranceEnum> getShowInsuranceV2(){
        return Arrays.asList(MEDICAL_INSURANCE,ACCIDENT,EPIDEMIC,CRITICAL_ILLNESS);
    }

    public static PresentInsuranceEnum getByCode(Integer code) {
        PresentInsuranceEnum preInstallBatchStatusEnum = ENUM_MAP.get(code);
        if(Objects.isNull(preInstallBatchStatusEnum)){
            return null;
        }
        return preInstallBatchStatusEnum;
    }
}
