package cn.com.duiba.kjy.api.enums.sellerSwitchConfig;


import java.util.stream.Stream;

/**
 * Created by 小天 on 2020-01-17
 * 销售开关状态枚举
 *
 */
public enum SwitchEnum {
    /**
     *关闭
     */
    CLOSE(0,"关闭"),

    /**
     *打开
     */
    OPEN(1,"开启")
    ;

    SwitchEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private Integer code;
    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    public static SwitchEnum  getByCode(Integer code){
        return Stream.of(SwitchEnum.values()).filter(switchEnum -> switchEnum.getCode().equals(code)).findFirst().orElse(OPEN);
    }


}
