package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.activity.ActivityConfCustDto;
import cn.com.duiba.kjy.api.dto.activity.ActivityConfDto;

import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/3/14.
 */
@AdvancedFeignClient
public interface RemoteActivityConfService {

    ActivityConfDto findById(Long id);

    /**
     * 插入/更新数据库, 不做额外任何操作
     * @param dto 数据
     * @return 主键
     */
    Long insertOrUpdate(ActivityConfDto dto);

    Boolean saveOrUpdate(ActivityConfDto dto);

    Boolean batchSaveOrUpdate(List<ActivityConfDto> dtos);

    /**
     * @param sellerId
     * @param activityId
     * @return
     */
    ActivityConfDto findBySellerIdAndActivity(Long sellerId, Long activityId);

    Map<Long/*活动等级*/,ActivityConfDto> findMapBySellerIdAndActivity(Long sellerId, Long activityId);

    /**
     * 变更库存
     * @param dto
     * @return
     */
    int updateRemaining(ActivityConfDto dto);

    /**
     * 通过销售，活动，客户id获取是否在指定好友榜单中
     * @param sellerId
     * @param activityId
     * @param custId
     * @return
     */
    ActivityConfCustDto findTargetCust(Long sellerId, Long activityId, Long custId);

    /**
     * 根据sellerId 及 activityId查找代理人中奖配置
     * @param sellerId
     * @param contentIds
     * @return
     */
    List<ActivityConfDto> findBySellerIdAndActivityIds(Long sellerId,List<Long> contentIds);

}
