/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.presentInsurance;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum PresentInsuranceEnum {
    ACCIDENT(1, "\u4eba\u8eab\u610f\u5916\u9669", "\u610f\u5916\u578b\u8d60\u9669", "\u4eba\u8eab\u610f\u5916\u4fdd\u969c", "https://yun.duiba.com.cn/kjy/media/image/20200822/8378fa00b013ef919b01703d0e7fa71e.png?x-oss-process=image/quality,q_80", "%s\u5143\u4fdd\u989d [\u4eba\u8eab\u5b89\u5168\u610f\u5916\u9669]", "\u610f\u5916\u4f24\u5bb3\u4e8b\u6545\u4fdd\u969c", "\u610f\u5916\u4e8b\u6545\u6709\u4fdd\u969c", "\u610f\u5916\u9669\u514d\u8d39\u4fdd\u989d%s"),
    CRITICAL_ILLNESS(2, "\u91cd\u75be\u9669", "\u91cd\u75be\u578b\u8d60\u9669", "\u5927\u75c5\u4fdd\u969c\u91cd\u75be\u9669", "https://yun.duiba.com.cn/kjy/media/image/20200822/ebfdcc5045b8b479a0c8b6ba17c76f01.png?x-oss-process=image/quality,q_80", "%s\u5143\u4fdd\u989d [\u5927\u75c5\u65e0\u5fe7\u91cd\u75be\u9669]", "\u5f97\u4e86\u5927\u75c5\u4e5f\u4e0d\u6015", "\u91cd\u5927\u75be\u75c5\u4e0d\u72af\u6101", "\u91cd\u75be\u9669\u514d\u8d39\u4fdd\u989d%s"),
    EPIDEMIC(3, "\u75ab\u60c5\u9669", "\u75ab\u60c5\u578b\u8d60\u9669", "\u65b0\u51a0\u80ba\u708e\u75ab\u60c5\u9669", "https://yun.duiba.com.cn/kjy/media/image/20200822/d0cd4102309257d0665d36231e382e0e.png?x-oss-process=image/quality,q_80", "%s\u5143\u4fdd\u989d [\u65b0\u51a0\u80ba\u708e\u75ab\u60c5\u9669]", "\u75ab\u60c5\u4e4b\u4e0b\uff0c\u4eba\u4eba\u5fc5\u5907", "\u5171\u540c\u9632\u62a4\u65b0\u51a0\u80ba\u708e", "\u75ab\u60c5\u9669\u514d\u8d39\u4fdd\u989d%s"),
    MEDICAL_INSURANCE(4, "\u533b\u7597\u9669", "\u533b\u7597\u578b\u8d60\u9669", "\u5065\u5eb7\u65e0\u5fe7\u533b\u7597\u9669", "https://yun.duiba.com.cn/kjy/media/image/20200822/86d9c9f1322ed1188080fcf841b7bc2c.png?x-oss-process=image/quality,q_80", "%s\u5143\u4fdd\u989d [\u5065\u5eb7\u65e0\u5fe7\u533b\u7597\u9669]", "\u514d\u8d39\u62a5\u9500\u770b\u75c5\u8d39\u7528", "\u770b\u75c5\u4e0d\u518d\u82b1\u94b1", "\u533b\u7597\u9669\u514d\u8d39\u4fdd\u989d%s");

    private Integer code;
    private String desc;
    private String pushDesc;
    private String title;
    private String image;
    private String clueSummary;
    private String content;
    private String columnTitle;
    private String columnContent;
    private static final Map<Integer, PresentInsuranceEnum> ENUM_MAP;

    private PresentInsuranceEnum(Integer code, String desc, String pushDesc, String title, String image, String clueSummary, String content, String columnTitle, String columnContent) {
        this.code = code;
        this.desc = desc;
        this.pushDesc = pushDesc;
        this.title = title;
        this.image = image;
        this.clueSummary = clueSummary;
        this.content = content;
        this.columnContent = columnContent;
        this.columnTitle = columnTitle;
    }

    public String getContent() {
        return this.content;
    }

    public String getImage() {
        return this.image;
    }

    public String getClueSummary() {
        return this.clueSummary;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getPushDesc() {
        return this.pushDesc;
    }

    public String getColumnContent() {
        return this.columnContent;
    }

    public String getColumnTitle() {
        return this.columnTitle;
    }

    public static List<PresentInsuranceEnum> getShowInsuranceV1() {
        return Arrays.asList(ACCIDENT, EPIDEMIC, CRITICAL_ILLNESS);
    }

    public static List<PresentInsuranceEnum> getShowInsuranceV2() {
        return Arrays.asList(MEDICAL_INSURANCE, ACCIDENT, EPIDEMIC, CRITICAL_ILLNESS);
    }

    public static PresentInsuranceEnum getByCode(Integer code) {
        PresentInsuranceEnum preInstallBatchStatusEnum = ENUM_MAP.get(code);
        if (Objects.isNull((Object)preInstallBatchStatusEnum)) {
            return null;
        }
        return preInstallBatchStatusEnum;
    }

    static {
        ENUM_MAP = new HashMap<Integer, PresentInsuranceEnum>();
        for (PresentInsuranceEnum tmp : PresentInsuranceEnum.values()) {
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }
}

