package cn.com.duiba.kjy.api.dto.pay;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhi
 * @date 2020/3/11 4:28 PM
 */
@Data
public class WxDuiBaRefundRecordDto implements Serializable {

    private static final long serialVersionUID = -7134727867563649225L;

    /**
     * 支付金额,单位：分
     */
    private Integer chargeAmount;

    /**
     * 申请退款金额,单位：分
     */
    private Integer applyRefundAmount;

    /**
     * 客集集订单号
     */
    private String bizOrderNo;

    /**
     * 兑吧分配给业务方的类型和bizOrderNo配合使用
     */
    private Integer bizType;

    /**
     * 第三方支付支付流水号,微信支付订单号
     */
    private String transactionNo;

    /**
     * 描述
     */
    private String description;

    /**
     * 商户退款单号
     */
    private String refundOrderNo;

    /**
     * 微信退款单号
     */
    private String refundNo;

    /**
     * 实际退款金额,单位：分
     */
    private Integer refundAmount;

    /**
     * 兑吧appId，兑吧返回
     */
    private Long appId;

    /**
     * 支付状态，兑吧返回
     * @see cn.com.duiba.kjy.api.enums.pay.RefundStatusEnum
     */
    private Integer refundStatus;

    /**
     * 退款时间，兑吧返回
     */
    private Date refundTime;

    /**
     * 渠道返回的错误码，兑吧返回
     */
    private String failureCode;

    /**
     * 渠道返回的错误信息
     */
    private String failureMsg;

    /**
     * 客集集业务类型
     */
    private Integer kjjBizType;

    /**
     * 客集集业务对应表的主键
     */
    private Long kjjBizId;

    /**
     * 渠道：0-兑吧，1-客集集支付系统
     * @see cn.com.duiba.kjy.api.enums.PayChannelEnum
     */
    private Integer payChannel;

    /**
     * 业务方的退款订单单号
     */
    private String bizRefundNo;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}
