package cn.com.duiba.kjy.api.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * 节日提醒日期枚举
 * @Author chentiecheng
 * @Date 2020/6/11 9:53 上午
 */
public enum HolidayRemindDateEnum {
    //元旦、春节、清明节、劳动节、端午节、中秋节、国庆节、立春、立夏、立秋、立冬、冬至、圣诞节
    //2020年
    NEW_YEAR_2020("2020-01-01","元旦"),
    SPRING_FESTIVAL_2020("2020-01-25","春节"),
    SPRING_BEGINS_2020("2020-02-04","立春"),
    QINGMING_FESTIVAL_2020("2020-04-04","清明节"),
    WORK_FESTIVAL_2020("2020-05-01","劳动节"),
    SUMMER_BEGINS_2020("2020-05-05","立夏"),
    DRAGON_BOAT_FESTIVAL_2020("2020-06-25","端午节"),
    AUTUMN_BEGINS_2020("2020-08-07","立秋"),
    NATIONAL_DAY_2020("2020-10-01","国庆节"),
    MID_AUTUMN_FESTIVAL_2020("2020-10-01","中秋节"),
    WINTER_BEGINS_2020("2020-11-07","立冬"),
    SOLSTICE_2020("2020-12-21","冬至"),
    CHRISTMAS_2020("2020-12-25","圣诞节"),
    //2021年
    NEW_YEAR_2021("2021-01-01","元旦"),
    SPRING_FESTIVAL_2021("2021-02-12","春节"),
    SPRING_BEGINS_2021("2021-02-03","立春"),
    QINGMING_FESTIVAL_2021("2021-04-04","清明节"),
    WORK_FESTIVAL_2021("2021-05-01","劳动节"),
    SUMMER_BEGINS_2021("2021-05-05","立夏"),
    DRAGON_BOAT_FESTIVAL_2021("2021-06-14","端午节"),
    AUTUMN_BEGINS_2021("2021-08-07","立秋"),
    NATIONAL_DAY_2021("2021-10-01","国庆节"),
    MID_AUTUMN_FESTIVAL_2021("2021-09-21","中秋节"),
    WINTER_BEGINS_2021("2021-11-07","立冬"),
    SOLSTICE_2021("2021-12-21","冬至"),
    CHRISTMAS_2021("2021-12-25","圣诞节"),
    //2022年
    NEW_YEAR_2022("2022-01-01","元旦"),
    SPRING_FESTIVAL_2022("2022-02-01","春节"),
    SPRING_BEGINS_2022("2022-02-04","立春"),
    QINGMING_FESTIVAL_2022("2022-04-05","清明节"),
    WORK_FESTIVAL_2022("2022-05-01","劳动节"),
    SUMMER_BEGINS_2022("2022-05-05","立夏"),
    DRAGON_BOAT_FESTIVAL_2022("2022-06-03","端午节"),
    AUTUMN_BEGINS_2022("2022-08-07","立秋"),
    NATIONAL_DAY_2022("2022-10-01","国庆节"),
    MID_AUTUMN_FESTIVAL_2022("2022-09-10","中秋节"),
    WINTER_BEGINS_2022("2022-11-07","立冬"),
    SOLSTICE_2022("2022-12-22","冬至"),
    CHRISTMAS_2022("2022-12-25","圣诞节"),
    //2023年
    NEW_YEAR_2023("2023-01-01","元旦"),
    SPRING_FESTIVAL_2023("2023-01-22","春节"),
    SPRING_BEGINS_2023("2023-02-04","立春"),
    QINGMING_FESTIVAL_2023("2023-04-05","清明节"),
    WORK_FESTIVAL_2023("2023-05-01","劳动节"),
    SUMMER_BEGINS_2023("2023-05-06","立夏"),
    DRAGON_BOAT_FESTIVAL_2023("2023-06-22","端午节"),
    AUTUMN_BEGINS_2023("2023-08-08","立秋"),
    NATIONAL_DAY_2023("2023-10-01","国庆节"),
    MID_AUTUMN_FESTIVAL_2023("2023-09-29","中秋节"),
    WINTER_BEGINS_2023("2023-11-08","立冬"),
    SOLSTICE_2023("2023-12-22","冬至"),
    CHRISTMAS_2023("2023-12-25","圣诞节"),
    //2024年
    NEW_YEAR_2024("2024-01-01","元旦"),
    SPRING_FESTIVAL_2024("2024-02-10","春节"),
    SPRING_BEGINS_2024("2024-02-04","立春"),
    QINGMING_FESTIVAL_2024("2024-04-04","清明节"),
    WORK_FESTIVAL_2024("2024-05-01","劳动节"),
    SUMMER_BEGINS_2024("2024-05-05","立夏"),
    DRAGON_BOAT_FESTIVAL_2024("2024-06-10","端午节"),
    AUTUMN_BEGINS_2024("2024-08-07","立秋"),
    NATIONAL_DAY_2024("2024-10-01","国庆节"),
    MID_AUTUMN_FESTIVAL_2024("2024-09-17","中秋节"),
    WINTER_BEGINS_2024("2024-11-07","立冬"),
    SOLSTICE_2024("2024-12-21","冬至"),
    CHRISTMAS_2024("2024-12-25","圣诞节"),
    //2025年
    NEW_YEAR_2025("2025-01-01","元旦"),
    SPRING_FESTIVAL_2025("2025-01-29","春节"),
    SPRING_BEGINS_2025("2025-02-03","立春"),
    QINGMING_FESTIVAL_2025("2025-04-04","清明节"),
    WORK_FESTIVAL_2025("2025-05-01","劳动节"),
    SUMMER_BEGINS_2025("2025-05-05","立夏"),
    DRAGON_BOAT_FESTIVAL_2025("2025-05-31","端午节"),
    AUTUMN_BEGINS_2025("2025-08-07","立秋"),
    NATIONAL_DAY_2025("2025-10-01","国庆节"),
    MID_AUTUMN_FESTIVAL_2025("2025-10-06","中秋节"),
    WINTER_BEGINS_2025("2025-11-07","立冬"),
    SOLSTICE_2025("2025-12-21","冬至"),
    CHRISTMAS_2025("2025-12-25","圣诞节"),
    //2026年
    NEW_YEAR_2026("2026-01-01","元旦"),
    SPRING_FESTIVAL_2026("2026-02-17","春节"),
    SPRING_BEGINS_2026("2026-02-04","立春"),
    QINGMING_FESTIVAL_2026("2026-04-05","清明节"),
    WORK_FESTIVAL_2026("2026-05-01","劳动节"),
    SUMMER_BEGINS_2026("2026-05-05","立夏"),
    DRAGON_BOAT_FESTIVAL_2026("2026-06-19","端午节"),
    AUTUMN_BEGINS_2026("2026-08-07","立秋"),
    NATIONAL_DAY_2026("2026-10-01","国庆节"),
    MID_AUTUMN_FESTIVAL_2026("2026-09-25","中秋节"),
    WINTER_BEGINS_2026("2026-11-07","立冬"),
    SOLSTICE_2026("2026-12-22","冬至"),
    CHRISTMAS_2026("2026-12-25","圣诞节"),
    //2027年
    NEW_YEAR_2027("2027-01-01","元旦"),
    SPRING_FESTIVAL_2027("2027-02-06","春节"),
    SPRING_BEGINS_2027("2027-02-04","立春"),
    QINGMING_FESTIVAL_2027("2027-04-05","清明节"),
    WORK_FESTIVAL_2027("2027-05-01","劳动节"),
    SUMMER_BEGINS_2027("2027-05-06","立夏"),
    DRAGON_BOAT_FESTIVAL_2027("2027-06-09","端午节"),
    AUTUMN_BEGINS_2027("2027-08-08","立秋"),
    NATIONAL_DAY_2027("2027-10-01","国庆节"),
    MID_AUTUMN_FESTIVAL_2027("2027-09-15","中秋节"),
    WINTER_BEGINS_2027("2027-11-07","立冬"),
    SOLSTICE_2027("2027-12-22","冬至"),
    CHRISTMAS_2027("2027-12-25","圣诞节"),
    //2028年
    NEW_YEAR_2028("2028-01-01","元旦"),
    SPRING_FESTIVAL_2028("2028-01-26","春节"),
    SPRING_BEGINS_2028("2028-02-04","立春"),
    QINGMING_FESTIVAL_2028("2028-04-04","清明节"),
    WORK_FESTIVAL_2028("2028-05-01","劳动节"),
    SUMMER_BEGINS_2028("2028-05-05","立夏"),
    DRAGON_BOAT_FESTIVAL_2028("2028-05-28","端午节"),
    AUTUMN_BEGINS_2028("2028-08-07","立秋"),
    NATIONAL_DAY_2028("2028-10-01","国庆节"),
    MID_AUTUMN_FESTIVAL_2028("2028-10-03","中秋节"),
    WINTER_BEGINS_2028("2028-11-07","立冬"),
    SOLSTICE_2028("2028-12-21","冬至"),
    CHRISTMAS_2028("2028-12-25","圣诞节"),
    //2029年
    NEW_YEAR_2029("2029-01-01","元旦"),
    SPRING_FESTIVAL_2029("2029-02-13","春节"),
    SPRING_BEGINS_2029("2029-02-03","立春"),
    QINGMING_FESTIVAL_2029("2029-04-04","清明节"),
    WORK_FESTIVAL_2029("2029-05-01","劳动节"),
    SUMMER_BEGINS_2029("2029-05-05","立夏"),
    DRAGON_BOAT_FESTIVAL_2029("2029-06-16","端午节"),
    AUTUMN_BEGINS_2029("2029-08-07","立秋"),
    NATIONAL_DAY_2029("2029-10-01","国庆节"),
    MID_AUTUMN_FESTIVAL_2029("2029-09-22","中秋节"),
    WINTER_BEGINS_2029("2029-11-07","立冬"),
    SOLSTICE_2029("2029-12-21","冬至"),
    CHRISTMAS_2029("2029-12-25","圣诞节"),
    //2030年
    NEW_YEAR_2030("2030-01-01","元旦"),
    SPRING_FESTIVAL_2030("2030-02-03","春节"),
    SPRING_BEGINS_2030("2030-02-04","立春"),
    QINGMING_FESTIVAL_2030("2030-04-05","清明节"),
    WORK_FESTIVAL_2030("2030-05-01","劳动节"),
    SUMMER_BEGINS_2030("2030-05-05","立夏"),
    DRAGON_BOAT_FESTIVAL_2030("2030-06-05","端午节"),
    AUTUMN_BEGINS_2030("2030-08-07","立秋"),
    NATIONAL_DAY_2030("2030-10-01","国庆节"),
    MID_AUTUMN_FESTIVAL_2030("2030-09-12","中秋节"),
    WINTER_BEGINS_2030("2030-11-07","立冬"),
    SOLSTICE_2030("2030-12-22","冬至"),
    CHRISTMAS_2030("2030-12-25","圣诞节"),

    ;

    private String date;
    private String desc;

    HolidayRemindDateEnum(String date, String desc) {
        this.date = date;
        this.desc = desc;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static List<HolidayRemindDateEnum> getHolidayByDate(String date){
        if(StringUtils.isBlank(date)){
            return Collections.emptyList();
        }
        List<HolidayRemindDateEnum> remindDateEnums = new ArrayList<>();
        for (HolidayRemindDateEnum dateEnum : HolidayRemindDateEnum.values()){
            if(Objects.equals(dateEnum.date,date)){
                remindDateEnums.add(dateEnum);
            }
        }
        return remindDateEnums;
    }
}
