package cn.com.duiba.kjy.api.enums.process;

import java.util.HashMap;
import java.util.Map;

/**
 * 审批流程角色状态枚举
 * @author xiaotian
 * @date 2020/1/7 3:43 PM
 */
public enum ProcessRoleStatusEnum {

    /**
     * 使用中
     */
    USE(1),

    /**
     * 删除状态
     */
    DEL(0)
    ;

    private Integer code;

    ProcessRoleStatusEnum(Integer code) {
        this.code = code;
    }


    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, ProcessRoleStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ProcessRoleStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static ProcessRoleStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }



}
