package cn.com.duiba.kjy.api.params.seller;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 销售客户自定义提醒参数
 * @Author chentiecheng
 * @Date 2020/6/8 3:52 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerCustomRemindParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = -7311403884187078680L;
    /**
     * 销售id
     */
    private Long sellerId;
    /**
     * 提醒状态
     * @see cn.com.duiba.kjy.api.enums.seller.CustomRemindStatusEnum
     */
    private Integer remindStatus;

    /**
     * 客户id
     */
    private Long customerId;
}
