package cn.com.duiba.kjy.api.remoteservice.clockin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.clockin.ClockInTaskDayDto;

import java.util.Date;
import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2020-06-29 19:56
 * @description: 60天打卡任务-每日任务
 */
@AdvancedFeignClient
public interface RemoteClockInTaskDayService {

    /**
     * 根据任务id根据日期查询
     * @param taskId
     * @param doneTime
     * @return
     */
    ClockInTaskDayDto findByTaskIdAndTime(Long taskId,Date doneTime);

    /**
     * 根据任务id查询每日任务列表
     * @param taskId
     * @return
     */
    List<ClockInTaskDayDto> findTaskDayListByTaskId(Long taskId);

}
