package cn.com.duiba.kjy.api.enums.explosioncontent;

import lombok.Getter;

/**
 * 焦虑类型枚举
 * @author xiaotian
 * @date 2020-07-13 17:57
 **/
@Getter
public enum AnxietyEnum {

    CHILD(1,"育儿焦虑","少儿成长投保攻略","你的育儿方案待领取","了解子女成长常见问题"),
    ASSET(2,"财产焦虑","资产规划投保攻略","开启小白理财第一步","你的理财规划方案待领取"),
    MIDDLE_AGE(3,"中年焦虑","家庭安全投保攻略","你的家庭保障方案待领取","规避风险，守护全家"),
    ACCIDENT(4,"意外焦虑","意外防范投保攻略","生活意外早预防","你的意外保障方案待领取"),
    HEALTH(5,"健康焦虑","健康无忧投保攻略","你的健康生活方案待领取","人人必备的常见疾病预防指南"),
    OLD(6,"养老焦虑","老年保障投保攻略","老年生活早规划","你的养老方案待领取")
    ;
    private Integer code;
    private String desc;
    private String materialDesc;
    /**
     * 个人专栏title
     */
    private String columnTitle;

    /**
     * 个人专栏content
     */
    private String columnContent;

    AnxietyEnum(Integer code, String desc,String materialDesc, String columnTitle,String columnContent) {
        this.code = code;
        this.desc = desc;
        this.materialDesc = materialDesc;
        this.columnTitle = columnTitle;
        this.columnContent = columnContent;
    }

    public static AnxietyEnum  getByCode(Integer code){
        for (AnxietyEnum anxietyEnum : AnxietyEnum.values()){
            if(anxietyEnum.getCode().equals(code)){
                return anxietyEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public String getColumnTitle() {
        return columnTitle;
    }

    public String getColumnContent() {
        return columnContent;
    }
}
