/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.clue;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public enum VisitClueTypeEnum {
    NORMAL_VISIT(0, "\u666e\u901a\u8bbf\u95ee", 0),
    FREQUENTLY_VISIT(1, "\u8fde\u7eed\u8bbf\u95ee", 100),
    DEPT_VISIT(2, "\u6df1\u5ea6\u8bbf\u95ee", 200),
    MATERIAL_VISIT(3, "\u63d0\u4ea4\u8d44\u6599\u7684\u8bbf\u95ee", 300),
    SALE_VISIT(4, "\u9500\u552e\u673a\u4f1a\u8bbf\u95ee", 400),
    VOTE_VISIT(5, "\u6295\u7968\u8bbf\u95ee", 500),
    ANSWER_VISIT(6, "\u7b54\u9898\u8bbf\u95ee", 600),
    LOTTERY_VISIT(7, "\u4e2d\u5956\u8bbf\u95ee", 700),
    PRODUCT_VISIT(8, "\u4ea7\u54c1\u7d20\u6750\u8bbf\u95ee", 800),
    MONTH_ACCUMULATE_VISIT(9, "1\u4e2a\u6708\u5185\u7d2f\u8ba1\u6709\u6548\u9605\u8bfb3\u4e2a\u4fdd\u9669\u7c7b\u7d20\u6750", 900),
    PRIVATE_FAQ_VISIT(10, "\u4fdd\u9669\u7406\u5ff5\u7c7bFAQ", 1000),
    CLUE_ACTIVITY_SUBMIT_MATERIAL(11, "\u7ebf\u7d22\u7c7b\u5c0f\u6e38\u620f", 2000),
    REMARK_NAME_EDIT(12, "\u65b0\u5ba2\u6237\u5907\u6ce8\u540d\u4fee\u6539", 1200),
    LOOK_OVER_COMPANY_INFO(13, "\u67e5\u770b\u516c\u53f8\u4fe1\u606f", 1300),
    ASK_EMPLOY_INFO(14, "\u8be2\u95ee\u62db\u8058\u7c7b\u4fe1\u606f", 1400),
    REVENUE_TALK_MATERIAL(15, "\u521b\u8bf4\u4f1a\u7559\u8d44", 1500),
    RECRUIT_FAQ_VISIT(16, "\u589e\u5458\u4e13\u9898\u7c7bFAQ", 1350),
    LOOK_OVER_HEADWORD(17, "\u79cd\u8349\u6b63\u6587\u5185\u4ec5\u67e5\u770b\u8bcd\u6761", 1600),
    LOOK_OVER_CLAIM_CASE(18, "\u79cd\u8349\u6b63\u6587\u5185\u7684\u7406\u8d54\u6848\u4f8b", 1700),
    LOOK_OVER_PRODUCT_ARTICLE(19, "\u79cd\u8349\u6b63\u6587\u5185\u7684\u4ea7\u54c1\u6587\u7ae0", 1800),
    EXPLOSION_VOTE(20, "\u53c2\u4e0e\u79cd\u8349\u6b63\u6587\u5185\u7684\u6295\u7968", 1900),
    HEADWORD_FAQ_VISIT(21, "\u8bcd\u6761\u5185\u7684FAQ\u8bbf\u95ee", 2100),
    LOOK_OVER_FAQ(22, "\u79cd\u8349\u6b63\u6587\u5185\u7684FAQ", 2200),
    FAQ_VISIT_NEW_ARTICLE(23, "FAQ\u8be6\u60c5\u9875\u8bbf\u95ee\u6587\u7ae0\u5185", 2300),
    FAQ_VISIT_NEW_COLUMN(24, "FAQ\u8be6\u60c5\u9875\u8bbf\u95ee\u6587\u4e2a\u4eba\u4e13\u680f", 2400),
    FAQ_VISIT_NEW_ASK_ARTICLE(25, "FAQ\u8be6\u60c5\u9875\u8bbf\u95ee\u6587\u7ae0\u5185,\u70b9\u51fb\u54a8\u8be2", 2500),
    FAQ_VISIT_NEW_ASK_COLUMN(26, "FAQ\u8be6\u60c5\u9875\u8bbf\u95ee\u6587\u4e2a\u4eba\u4e13\u680f,\u70b9\u51fb\u54a8\u8be2", 2600),
    FAQ_VISIT_DETAIL(27, "\u67e5\u770bFAQ\u95ee\u7b54", 2700),
    FAQ_VISIT_ASK(28, "\u67e5\u770bFAQ\u95ee\u7b54\uff0c\u70b9\u51fb\u54a8\u8be2", 2800),
    FAQ_VISIT_SCAN(29, "\u67e5\u770bFAQ\u95ee\u7b54,\u626b\u63cf\u4e8c\u7ef4\u7801", 2900),
    FAQ_VISIT_EXTRA_QUESTION(30, "\u67e5\u770bFAQ\u95ee\u7b54,\u989d\u5916\u95ee\u7b54\u54a8\u8be2", 2899),
    WELFARE_INSURANCE(31, "\u8d60\u9669\u9886\u53d6", 3100),
    RISK_TEST(32, "\u98ce\u9669\u8bc4\u6d4b\u91cd\u8981\u7ebf\u7d22", 2001),
    VISIT_DATAGRAM_ARTICLE(33, "\u8bbf\u95ee\u4e86\u8d44\u6599\u5305\u6587\u7ae0", 3300),
    ONE_BY_ONE(34, "1V1\u5b9a\u5236", 3400);

    private Integer code;
    private String description;
    private Integer order;

    private VisitClueTypeEnum(Integer code, String description, Integer order) {
        this.code = code;
        this.description = description;
        this.order = order;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getOrder() {
        return this.order;
    }

    public static List<Integer> getSaleChanceCode() {
        return Lists.newArrayList((Object[])new Integer[]{PRIVATE_FAQ_VISIT.getCode(), CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode(), MONTH_ACCUMULATE_VISIT.getCode(), PRODUCT_VISIT.getCode(), FAQ_VISIT_NEW_ARTICLE.getCode(), FAQ_VISIT_NEW_COLUMN.getCode(), FAQ_VISIT_NEW_ASK_COLUMN.getCode(), FAQ_VISIT_NEW_ASK_ARTICLE.getCode(), FAQ_VISIT_DETAIL.getCode(), FAQ_VISIT_SCAN.getCode(), FAQ_VISIT_ASK.getCode(), FAQ_VISIT_EXTRA_QUESTION.getCode(), ONE_BY_ONE.getCode()});
    }

    public static List<Integer> getRecruitChanceCode() {
        return Lists.newArrayList((Object[])new Integer[]{RECRUIT_FAQ_VISIT.getCode(), ASK_EMPLOY_INFO.getCode(), LOOK_OVER_COMPANY_INFO.getCode(), REVENUE_TALK_MATERIAL.getCode()});
    }

    public static VisitClueTypeEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (VisitClueTypeEnum visitClueTypeEnum : VisitClueTypeEnum.values()) {
            if (!Objects.equals(visitClueTypeEnum.getCode(), code)) continue;
            return visitClueTypeEnum;
        }
        return null;
    }

    public static boolean isDelayPush(Integer code) {
        return Objects.equals(VisitClueTypeEnum.NORMAL_VISIT.code, code) || Objects.equals(VisitClueTypeEnum.FREQUENTLY_VISIT.code, code) || Objects.equals(VisitClueTypeEnum.DEPT_VISIT.code, code) || Objects.equals(VisitClueTypeEnum.PRODUCT_VISIT.code, code) || Objects.equals(VisitClueTypeEnum.MONTH_ACCUMULATE_VISIT.code, code);
    }

    public static Integer getOrder(Integer code) {
        for (VisitClueTypeEnum visitClueTypeEnum : VisitClueTypeEnum.values()) {
            if (!Objects.equals(visitClueTypeEnum.code, code)) continue;
            return visitClueTypeEnum.order;
        }
        return 0;
    }

    public static boolean isSellerGainSaleClueDynamicType(Integer type) {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{VisitClueTypeEnum.DEPT_VISIT.code, VisitClueTypeEnum.MATERIAL_VISIT.code, VisitClueTypeEnum.PRIVATE_FAQ_VISIT.code, VisitClueTypeEnum.CLUE_ACTIVITY_SUBMIT_MATERIAL.code, VisitClueTypeEnum.MONTH_ACCUMULATE_VISIT.code, VisitClueTypeEnum.PRODUCT_VISIT.code, VisitClueTypeEnum.RECRUIT_FAQ_VISIT.code, VisitClueTypeEnum.LOOK_OVER_COMPANY_INFO.code, VisitClueTypeEnum.ASK_EMPLOY_INFO.code, VisitClueTypeEnum.REVENUE_TALK_MATERIAL.code, VisitClueTypeEnum.FAQ_VISIT_NEW_COLUMN.code, VisitClueTypeEnum.FAQ_VISIT_NEW_ASK_ARTICLE.code, VisitClueTypeEnum.FAQ_VISIT_NEW_ARTICLE.code, VisitClueTypeEnum.FAQ_VISIT_NEW_ASK_COLUMN.code, VisitClueTypeEnum.FAQ_VISIT_DETAIL.code, VisitClueTypeEnum.FAQ_VISIT_ASK.code, VisitClueTypeEnum.FAQ_VISIT_SCAN.code, VisitClueTypeEnum.FAQ_VISIT_EXTRA_QUESTION.code, VisitClueTypeEnum.WELFARE_INSURANCE.code, VisitClueTypeEnum.RISK_TEST.code, VisitClueTypeEnum.ONE_BY_ONE.code});
        return list.contains(type);
    }

    public static VisitClueTypeEnum getByEnumName(String name) {
        for (VisitClueTypeEnum visitClueTypeEnum : VisitClueTypeEnum.values()) {
            if (!StringUtils.equals((String)visitClueTypeEnum.toString(), (String)name)) continue;
            return visitClueTypeEnum;
        }
        return null;
    }

    public static List<Integer> getCustV3FAQClueTypes() {
        return Arrays.asList(PRIVATE_FAQ_VISIT.getCode(), RECRUIT_FAQ_VISIT.getCode(), HEADWORD_FAQ_VISIT.getCode(), LOOK_OVER_FAQ.getCode(), FAQ_VISIT_NEW_ARTICLE.getCode(), FAQ_VISIT_NEW_COLUMN.getCode(), FAQ_VISIT_NEW_ASK_ARTICLE.getCode(), FAQ_VISIT_NEW_ASK_COLUMN.getCode(), FAQ_VISIT_DETAIL.getCode(), FAQ_VISIT_ASK.getCode(), FAQ_VISIT_SCAN.getCode(), FAQ_VISIT_EXTRA_QUESTION.getCode());
    }

    public static List<Integer> getCustV3TestClueTypes() {
        return Arrays.asList(CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode());
    }

    public static List<Integer> getCustV3InsuranceClueTypes() {
        return Arrays.asList(PRIVATE_FAQ_VISIT.getCode(), HEADWORD_FAQ_VISIT.getCode(), LOOK_OVER_FAQ.getCode(), FAQ_VISIT_NEW_ARTICLE.getCode(), FAQ_VISIT_NEW_COLUMN.getCode(), FAQ_VISIT_NEW_ASK_ARTICLE.getCode(), FAQ_VISIT_NEW_ASK_COLUMN.getCode(), FAQ_VISIT_DETAIL.getCode(), CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode());
    }

    public static List<Integer> getCustV3RecruitmentClueTypes() {
        return Arrays.asList(RECRUIT_FAQ_VISIT.getCode(), ASK_EMPLOY_INFO.getCode(), LOOK_OVER_COMPANY_INFO.getCode(), REVENUE_TALK_MATERIAL.getCode());
    }

    public static List<Integer> getCustV3VoteClueTypes() {
        return Arrays.asList(EXPLOSION_VOTE.getCode());
    }

    public static List<Integer> getCustV3ImportantClueTypes() {
        return Arrays.asList(FAQ_VISIT_SCAN.getCode(), VisitClueTypeEnum.FAQ_VISIT_ASK.code, VisitClueTypeEnum.FAQ_VISIT_EXTRA_QUESTION.code, WELFARE_INSURANCE.getCode(), RISK_TEST.getCode(), ONE_BY_ONE.getCode());
    }

    public static List<Integer> getValidClues() {
        return Arrays.asList(PRIVATE_FAQ_VISIT.getCode(), CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode(), RECRUIT_FAQ_VISIT.getCode(), LOOK_OVER_HEADWORD.getCode(), LOOK_OVER_CLAIM_CASE.getCode(), LOOK_OVER_PRODUCT_ARTICLE.getCode(), EXPLOSION_VOTE.getCode(), HEADWORD_FAQ_VISIT.getCode(), LOOK_OVER_FAQ.getCode(), FAQ_VISIT_NEW_ARTICLE.getCode(), FAQ_VISIT_NEW_COLUMN.getCode(), FAQ_VISIT_NEW_ASK_ARTICLE.getCode(), FAQ_VISIT_NEW_ASK_COLUMN.getCode(), FAQ_VISIT_ASK.getCode(), FAQ_VISIT_DETAIL.getCode(), FAQ_VISIT_SCAN.getCode(), FAQ_VISIT_EXTRA_QUESTION.getCode(), WELFARE_INSURANCE.getCode(), RISK_TEST.getCode(), VISIT_DATAGRAM_ARTICLE.getCode(), ONE_BY_ONE.getCode());
    }

    public static List<Integer> getSellerCustomerIntentionClues() {
        return Arrays.asList(CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode(), FAQ_VISIT_DETAIL.getCode(), FAQ_VISIT_ASK.getCode(), FAQ_VISIT_SCAN.getCode(), FAQ_VISIT_EXTRA_QUESTION.getCode(), WELFARE_INSURANCE.getCode(), RISK_TEST.getCode(), ONE_BY_ONE.getCode());
    }

    public static List<Integer> getBillingPlanImportantClueTypes() {
        return Arrays.asList(FAQ_VISIT_SCAN.getCode(), WELFARE_INSURANCE.getCode(), RISK_TEST.getCode());
    }
}

