package cn.com.duiba.kjy.api.dto.billing;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 代理人开单打卡任务dto
*/
@Data
public class BillingClockTaskDto implements Serializable {

    private static final long serialVersionUID = -2934882744365852096L;
    /**
    * 主键
    */
    private Long id;

    /**
    * tb_billing_day_state主键ID
    */
    private Long dayStateId;

    /**
    * 代理人ID
    */
    private Long sellerId;

    /**
    * 状态 1:进行中 2:完成
    */
    private Integer taskStatus;

    /**
    * 任务类型,1转发种草文章,2转发种草视频,3客户备注分类,4跟进重要线索,5转发早报,6查看周报,7使用测试工具,8使用抽奖工具
    */
    private Integer taskType;

    /**
    * 任务完成时间
    */
    private Date completedDate;

    /**
    * 任务需要完成次数
    */
    private Integer needFinishTimes;

    /**
    * 已完成次数
    */
    private Integer finishTimes;

    /**
    * 任务需要完成时间
    */
    private Integer needFinishDay;


}

