package cn.com.duiba.kjy.api.dto.sellerTryRecord;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @author kjj mybatis generator 
 * 2020-04-21
 */
@Data
public class SellerTryRecordDto implements Serializable {
    private static final long serialVersionUID = 15874324341367747L;

    private Long id;

    /**
     *
     *用户ID
     * not null default = null
     */
    private Long sellerId;

    private Long userId;

    /**
     *
     *试用权限类型 1:直播试用
     * not null default = null
     */
    private Integer tryType;

    /**
     *
     *试用开始时间
     * not null default = null
     */
    private Date tryStart;

    /**
     *
     *试用结束时间
     * not null default = null
     */
    private Date tryEnd;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否在试用时间内
     * @return true：在，false-不在
     */
    public boolean inTry() {
        if (tryEnd == null || tryStart == null) {
            return false;
        }
        Date now = new Date();
        //>= 开始时间，< 结束时间。 而不是 > 开始时间，< 结束时间
        //所以用!tryStart.after(now)
        return now.before(tryEnd) && (!tryStart.after(now));
    }
}