package cn.com.duiba.kjy.api.enums.billing;

import java.util.HashMap;
import java.util.Map;

/**
 * 60天开单计划任务类型
 * @author zhanghuifeng
 * date 2020/11/17-11:19
 */
public enum BillingClockTaskTypeEnum {

    FORWARD_SEEDING_ARTICLE(1, "转发种草文章"),
    FORWARD_SEEDING_VIDEO(2, "转发种草视频"),
    CUSTOMER_REMARK(3, "客户备注分类"),
    CHECK_FOLLOW_CLUE(4, "跟进重要线索"),
    FORWARD_DAILY(5, "转发早报"),
    CHECK_WEEKLY_REPORTS(6, "查看周报"),
    USE_TEST_TOOL(7, "使用测试工具"),
    USE_LOTTERY_TOOL(8, "使用抽奖工具"),
    ;

    private Integer code;
    private String desc;

    BillingClockTaskTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, BillingClockTaskTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(BillingClockTaskTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static BillingClockTaskTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
