package cn.com.duiba.kjy.api.enums.dailyPosters;

import java.util.Objects;

/**
 * 每日唤醒推送海报配置类型
 * @Author chentiecheng
 * @Date 2020/6/16 4:39 下午
 */
public enum DailyPostersConfigTypeEnum {
    DAILY(1,"每日早报"),
    GRASS_CONTENT(2,"种草素材"),
    HOT_ARTICLE(3,"今日热文"),
    EVENING(4,"晚安心语"),
    ;

    private Integer type;
    private String desc;

    DailyPostersConfigTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据类型获取配置
     * @param type
     * @return
     */
    public static final DailyPostersConfigTypeEnum getByType(Integer type){
        if(Objects.isNull(type)){
            return null;
        }
        for (DailyPostersConfigTypeEnum dailyPostersConfigTypeEnum:DailyPostersConfigTypeEnum.values()){
            if(Objects.equals(dailyPostersConfigTypeEnum.type,type)){
                return dailyPostersConfigTypeEnum;
            }
        }
        return null;
    }
}
