package cn.com.duiba.kjy.api.params.seller;

import cn.com.duiba.kjy.api.enums.vip.VipTransferCheckStateEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author liuchao1
 * @date 2020/5/8 14:40
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class VipTransferVerifyRecordQueryParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = -617351494881204143L;

    /**
     * 原代理人id
     */
    private Long oldSellerId;

    /**
     * 新代理人id
     */
    private Long newSellerId;

    /**
     *
     * 审核状态 0:发起申请 1:待审核 2:审核通过 3:审核拒绝
     * @see VipTransferCheckStateEnum
     */
    private Integer checkState;

    /**
     * 不包含的审核状态
     * @see VipTransferCheckStateEnum
     */
    private Integer notContainCheckState;
}
