package cn.com.duiba.kjy.api.params.sellercard;

import cn.com.duiba.kjy.api.enums.sellercard.AuthStatusEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by dugq on 2019-08-01.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class DoAuth4AdminParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = 6245659421622635483L;

    /**
     * 批量认证Id
     */
    private List<Long> ids;
    /**
     * 审核人
     */
    private String admin;
    /**
     * 审核时间
     */
    private Date authDateTime;
    /**
     * 审核状态
     */
    private AuthStatusEnum statusEnum;
    /**
     * 拒绝理由
     */
    private String refuseReason;

    /**
     * 认证名称(其它认证专用)
     */
    private String authName;

    /**
     * 认证简称(其它认证专用)
     */
    private String authSimpleName;


}
