package cn.com.duiba.kjy.api.params.version;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 用户版本查询参数
 * @author 吴文哲
 * @date 2020-02-05 20:09
 **/
@Data
public class UserVersionParam implements Serializable {
    private static final long serialVersionUID = 3147521957577193213L;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * userid列表
     */
    private List<Long> userIds;

    /**
     * 代理人id列表
     */
    private List<Long> sellerIds;

    /**
     * 是否启用 0:未启用  1启用
     */
    private Integer openType;

    /**
     * 用户版本
     * @see cn.com.duiba.kjy.api.enums.version.UserVersionEnum
     */
    private Integer userVersion;
}
