package cn.com.duiba.kjy.api.remoteservice.billing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.billing.BillingClockDto;

/**
 * 60天开单打卡remote
 * @author zhanghuifeng
 * date 2020/11/17-16:54
 */
@AdvancedFeignClient
public interface RemoteBillingClockService {

    /**
     * 根据代理人ID查询
     * @param sellerId 代理人ID
     * @return 开单打卡信息
     */
    BillingClockDto findBySellerId(Long sellerId);

    /**
     * 初始化代理人60天开单打卡
     * @param sellerId 代理人ID
     */
    Boolean initClock(Long sellerId);

    /**
     * 补卡
     * @param sellerId 代理人ID
     * @param dataFlag 需要补卡为第几天
     * @return 结果
     */
    Boolean reissueCard(Long sellerId, Integer dataFlag);

}
