package cn.com.duiba.kjy.api.remoteservice.clockin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.clockin.ClockInTaskDto;

/**
 * @auther: linjianhui
 * @date: 2020-06-29 14:28
 * @description: 60天打卡任务
 */
@AdvancedFeignClient
public interface RemoteClockInTaskService {

    /**
     * 添加60天打卡任务
     * @param dto
     * @return
     */
    Long insert(ClockInTaskDto dto);

    /**
     * 通过销售id查询任务
     * @param sellerId
     * @return
     */
    ClockInTaskDto findTaskBySellerId(Long sellerId);

    /**
     * 更新任务状态
     * @param taskId
     * @param taskStatus
     * @return
     */
    Integer updateTaskStatus(Long taskId, Integer taskStatus);

    /**
     * 计算并获取销售任务进度
     * @param sellerId
     * @return
     */
    ClockInTaskDto getTaskScheduleBySellerId(Long sellerId);

}
