package cn.com.duiba.kjy.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.invitation.InvitationRecordDto;
import cn.com.duiba.kjy.api.params.invivation.InvitationRecordParam;

import java.util.List;

/**
 * 邀请函访问记录
 * @author 吴文哲
 * @date 2019-12-06 11:39
 **/
@AdvancedFeignClient
public interface RemoteInvitationRecordService {

    /**
     * 新增记录
     * @param addDto
     * @return
     */
    Integer addRecord(InvitationRecordDto addDto);


    /**
     * 根据访客id 邀请函id 查询邀请函访问记录
     * @param visitorId
     * @param invitationId
     * @return
     */
    InvitationRecordDto getRecordByVisitorIdAndInvitationId(Long visitorId,Long invitationId);

    /**
     * 访客接受邀请函
     * @param acceptDto
     * @return
     */
    Integer acceptInvitation(InvitationRecordDto acceptDto);


    /**
     * 统计
     * @param param
     * @return
     */
    Integer countByCondition(InvitationRecordParam param);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<InvitationRecordDto> listByCondition(InvitationRecordParam param);
}
