package cn.com.duiba.kjy.api.dto.billing;

import cn.com.duiba.kjy.api.enums.billing.BillingClockDrawStateEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 代理人开单打卡奖励领取记录Dto
*/
@Data
public class BillingClockAwardDrawDto implements Serializable {

    private static final long serialVersionUID = -6132540571890791690L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 代理人ID
    */
    private Long sellerId;

    /**
    * 奖励配置ID，tb_billing_clock_award_conf主键ID
    */
    private Long awardConfId;

    /**
    * 领取时间
    */
    private Date drawTime;

    /**
    * 领取状态，1待领取 2已领取
     * @see BillingClockDrawStateEnum
    */
    private Integer drawState;

}

