package cn.com.duiba.kjy.api.dto.serialPayRecord;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @author kjj mybatis generator 
 * 2020-04-16
 */
@Data
public class SerialPayRecordDto implements Serializable {
    private static final long serialVersionUID = 1587003452457539L;

    private Long id;

    /**
     *
     *付款人（公司）
     * max length = 45
     */
    private String payer;

    /**
     *
     *付款账号
     * max length = 45
     */
    private String payAccount;

    /**
     *
     *付款时间
     */
    private Date payTime;

    /**
     *
     *打款方式 1:招商银行 2:支付宝
     */
    private Integer payType;

    /**
     *
     *打款金额
     */
    private Integer payCount;

    /**
     *
     *流水号
     * max length = 45
     */
    private String serialNumber;

    /**
     *
     *审核状态 0:待审核 1:审核通过 2:审核失败
     * not null default = 0
     */
    private Integer checkStatus;

    /**
     *
     *审核留言
     * max length = 200
     */
    private String checkRemark;

    /**
     *
     *会员账号数量
     */
    private Integer vipCount;

    /**
     *
     *打款凭证截图
     * max length = 256
     */
    private String payImage;

    /**
     *
     *上传内部人员ID
     */
    private Long sellerId;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}