package cn.com.duiba.kjy.api.enums;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019-09-26 17:35
 * @descript
 */
public enum ChatContentTypeEnum {
    /**
     * 私信类型
     */
    TEXT_MESSAGE(1, "文本消息"),
    CARD_MESSAGE(2, "卡片消息"),
    PIC_TEXT_MESSAGE(3, "图文消息"),
    QUESTION_MESSAGE(4, "问答消息")
    ;

    private Integer code;
    private String description;

    ChatContentTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 需要在私信中展示的内容类型
     * @return
     */
    public static List<Integer> getNeedDisplayTypes() {
        return Lists.newArrayList(TEXT_MESSAGE.getCode(), CARD_MESSAGE.getCode(), PIC_TEXT_MESSAGE.getCode());
    }

}
