package cn.com.duiba.kjy.api.enums.billing;

import java.util.HashMap;
import java.util.Map;

/**
 * 60天开单打卡奖励类型
 * @author zhanghuifeng
 * date 2020/11/23-10:33
 */
public enum BillingClockAwardTypeEnum {

    VIP(1, "vip会员"),
    TICKET(2, "券"),
    ;

    private Integer code;
    private String desc;

    BillingClockAwardTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, BillingClockAwardTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(BillingClockAwardTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static BillingClockAwardTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
