package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.ActivationCodeBatchDto;
import cn.com.duiba.kjy.api.params.Activationcode.ActivationCodeBatchPageQryParams;

import java.util.List;

/**
 * 激活码批次服务
 * @author zhanghuifeng
 * date 2019-04-18-16:12
 */
@AdvancedFeignClient
public interface RemoteActivationCodeBatchService {

    /**
     * 批量添加
     * @param list
     * @return
     */
    Boolean batchInsert(List<ActivationCodeBatchDto> list);

    /**
     * 分页查询数据
     * @param param
     * @return
     */
    List<ActivationCodeBatchDto> findPageList(ActivationCodeBatchPageQryParams param);

    /**
     * 分页查询获取总数
     * @param param
     * @return
     */
    int findPageCount(ActivationCodeBatchPageQryParams param);

    /**
     * 根据公司ID获取批次数
     * @param companyId
     * @return
     */
    int findCountByCompany(Long companyId);
}
