package cn.com.duiba.kjy.api.dto.grabmaterial;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 爬虫文库详情
 * @Author chentiecheng
 * @Date 2020/3/8 4:18 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GrabMaterialDetailDto extends GrabMaterialDto {
    private static final long serialVersionUID = -5004995926843568135L;
    /**
     * 素材类型
     */
    private Integer materialType;
    /**
     * 视频链接封面图
     */
    private String videoImg;
    /**
     * 视频链接标题
     */
    private String videoTitle;
    /**
     * 文章/动画/测试id
     */
    private Long contentId;
    /**
     * 标签id
     */
    private Long materialTag;
    /**
     * 推荐优先级
     */
    private Integer recommendPriority;
    /**
     * 评论
     */
    private List<String> comments;
    /**
     * 转发人数级别
     */
    private Integer forwardRank;
    /**
     * 内容类型
     */
    private Integer contentVersion;

}
