package cn.com.duiba.kjy.api.params.feedback;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 反馈参数
 *
 * @author xuzhigang
 * @date 2021/7/13 4:34 下午
 **/
@Data
public class SellerFeedbackParam implements Serializable {
    private static final long serialVersionUID = 3694149028380499512L;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 代理人id集合
     */
    private List<Long> sellerIds;

    /**
     * 反馈类型 1-功能异常 2-体验问题 3-新功能建议 4-其他
     * @see cn.com.duiba.kjy.api.enums.feedback.FeedbackTypeEnum
     */
    private Integer feedbackType;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;
}
