package cn.com.duiba.kjy.api.remoteservice.honorary;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.honorary.VisitorHonoraryAlbumRecordDto;
import cn.com.duiba.kjy.api.params.honorary.VisitorHonoraryAlbumRecordParam;

import java.util.List;

/**
 * 荣誉相册记录rpc接口
 * @author liuchao1
 * @date 2020-04-20 13:50
 **/
@AdvancedFeignClient
public interface RemoteVisitorHonoraryAlbumRecordService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 荣誉相册访问记录
     */
    VisitorHonoraryAlbumRecordDto findById(Long id);

    /**
     * 根据配置id、访客id 获取访问记录
     * @param confId 配置ID
     * @param visitorId 访客userId
     * @return 荣誉相册访问记录
     */
    VisitorHonoraryAlbumRecordDto findByConfIdAndVisitorId(Long confId, Long visitorId);

    /**
     * 分页查询
     * @param param 分页参数
     * @return 荣誉相册访问记录集合
     */
    List<VisitorHonoraryAlbumRecordDto> findPage(VisitorHonoraryAlbumRecordParam param);

    /**
     * 获取或保存访问记录
     * @param dto 访问记录
     * @return 已有则返回最新的，没有则保存后再返回
     */
    VisitorHonoraryAlbumRecordDto getOrSaveRecord(VisitorHonoraryAlbumRecordDto dto);
}
