package cn.com.duiba.kjy.api.remoteservice.innersales;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.innersalesmng.InnerSalesDto;
import cn.com.duiba.kjy.api.params.innerSales.InnerSalesListParam;

import java.util.List;

/**
 * Created by dugq on 2020-01-06.
 */
@AdvancedFeignClient
public interface RemoteInnerSalesService {
    /**
     * 根据ID查询内部销售
     * @param id
     * @return
     */
    InnerSalesDto selectOne(Long id);

    /**
     * 根据Id获取列表
     * @param ids
     * @return
     */
    List<InnerSalesDto>  selectByIdList(List<Long> ids);


    /**
     * 根据userIdId获取列表
     * @param userIds
     * @return
     */
    List<InnerSalesDto>  selectByUserIdList(List<Long> userIds);


    /**
     * 根据tb_user表的ID查询用户
     * @param userId
     * @return
     */
    InnerSalesDto selectByUserId(Long userId);

    /**
     * 列表查询销售
     * @param param
     * @return
     */
    List<InnerSalesDto> selectList(InnerSalesListParam param);

    /**
     * 跟新内部销售信息
     * @param record
     * @return
     */
    int update(InnerSalesDto record);

    /**
     * 查询内部销售数量
     * @param pojo
     * @return
     */
    Integer selectCount(InnerSalesListParam pojo);

    /**
     * 新增内部销售
     * @param pojo
     * @return
     */
    Long insert(InnerSalesDto pojo);
}
