package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerCustomerMaterialDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerMaterialQryParam;

import java.util.List;
import java.util.Map;

/**
 * @author wangbinbin
 * @create 2019/6/29 17:18
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerMaterialService {

    /**
     * 根据代理人id和客户用户id查询数量
     * @param sellerId
     * @param userId
     * @return
     */
    Integer countNumBySellerIdAndUserId(Long sellerId, Long userId);


    /**
     * 查询列表  结果不自动分页
     * @param param
     * @return
     */
    List<SellerCustomerMaterialDto> listByParams(SellerCustomerMaterialQryParam param);


    /**
     * 分页查询提交资料
     * @param param
     * @return
     */
    Page<SellerCustomerMaterialDto> getMaterialPage(SellerCustomerMaterialQryParam param);

    /**
     * 根据材料id获取数据
     * @param materialId
     * @return
     */
    SellerCustomerMaterialDto listById(Long materialId);

    /**
     * 根据代理人内容id查询总数
     * @param scId
     * @return
     */
    Integer countNumByScId(Long scId);

    /**
     * 根据代理人内容Id查询提交资料
     * @param scId
     * @return key=userId value=Id
     */
    Map<Long, Long> getSubmitMaterialMenMapByScId(Long scId);


    /**
     * 新增或更新
     * @param dto
     * @return
     */
    Boolean saveOrUpdate(SellerCustomerMaterialDto dto);

    /**
     * 提交资料数
     * @return key = scId  value=提交资料的userIds
     */
    Map<Long, List<Long>> getSubmitMaterialNumMap(List<Long> scIds);

    /**
     * 根据用户id查找
     *
     * @param userId    用户id
     * @param contentId 文章id
     * @return
     */
    SellerCustomerMaterialDto findByUserId(Long userId, Long contentId, Long scId);

    /**
     * 统计所有提交资料的 非中奖活动 数量
     */
    Integer countMaterialBySellerIdAndUserId(Long sellerId,Long userId);

    /**
     * 根据访问记录找到对应的提交资料记录
     * @param tbVisitIds
     * @return
     */
    List<SellerCustomerMaterialDto> getMaterialsByTbVisitId(List<Long> tbVisitIds);

    /**
     * 提交资料中排除 contentIds
     * @return
     */
    List<SellerCustomerMaterialDto> getMaterialsExcludeCIds(List<Long> excludeCIds,Long sellerId);

    /**
     * 根据条件查询提交资料 并倒序分页
     * @return
     */
    List<SellerCustomerMaterialDto> getMaterialsByCondition(SellerCustomerMaterialQryParam param);

    /**
     * 根据条件查询提交资料
     * @return
     */
   Integer countMaterialsByCondition(SellerCustomerMaterialQryParam param);

    /**
     * 按scId 统计并分组
     * @param scIds
     * @return
     */
    Map<Long, Integer> countNumByScIds(List<Long> scIds);

    /**
     * 更新为已读
     * @param id
     * @return
     */
    Integer updateAlreadyRead(Long id);

    /**
     * 批量更新为已读
     * @param ids
     * @return
     */
    Integer updateAlreadyReadBatch(List<Long> ids);

    /**
     * 销售演示 插入专用
     * @param dto
     * @return
     */
    Long insertMaterialDto4SellerDemo(SellerCustomerMaterialDto dto);

    /**
     * 根据主键查找 销售演示专用
     * @param id
     * @return
     */
    SellerCustomerMaterialDto findById(Long id);


    /**
     * 根据主键查找
     * @param ids
     * @return
     */
    List<SellerCustomerMaterialDto> findByIds(List<Long> ids);
}
