package cn.com.duiba.kjy.api.remoteservice.sellercard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellerCase.SellerCaseDto;

import java.util.List;

/**
 * 代理人个人案例
 * @Author chentiecheng
 * @Date 2020/8/31 10:47 上午
 */
@AdvancedFeignClient
public interface RemoteSellerCaseService {

    /**
     * 新增个人案例
     * @param dto
     * @return
     */
    Boolean addCase(SellerCaseDto dto);

    /**
     * 更新个人案例
     * @param dto
     * @return
     */
    Boolean updateCase(SellerCaseDto dto);

    /**
     * 根据id删除个人案例
     * @param id
     * @return
     */
    Boolean deleteCaseById(Long id);

    /**
     * 更新展示状态
     * @param id
     * @param isShow
     * @return
     */
    Boolean updateShowStatus(Long id,Boolean isShow);

    /**
     * 根据id获取案例详情
     * @param id
     * @return
     */
    SellerCaseDto selectCaseById(Long id);

    /**
     * 根据销售id获取案例列表
     * @param sellerId
     * @return
     */
    List<SellerCaseDto> getSellerCardCaseList(Long sellerId);
}
