package cn.com.duiba.kjy.api.enums.clue;

import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2019-12-30 16:14
 * @descript 访问推送线索
 */
public enum VisitClueTypeEnum {
    NORMAL_VISIT(0, "普通访问", 0),
    @Deprecated
    FREQUENTLY_VISIT(1, "连续访问", 100),
    DEPT_VISIT(2, "深度访问", 200),
    MATERIAL_VISIT(3, "提交资料的访问", 300),
    @Deprecated
    SALE_VISIT(4, "销售机会访问", 400),
    VOTE_VISIT(5, "投票访问", 500),
    ANSWER_VISIT(6, "答题访问", 600),
    LOTTERY_VISIT(7, "中奖访问", 700),
    @Deprecated
    PRODUCT_VISIT(8, "产品素材访问", 800),
    @Deprecated
    MONTH_ACCUMULATE_VISIT(9, "1个月内累计有效阅读3个保险类素材", 900),
    @Deprecated
    PRIVATE_FAQ_VISIT(10, "保险理念类FAQ", 1000),
    CLUE_ACTIVITY_SUBMIT_MATERIAL(11, "线索类小游戏", 2000),
    @Deprecated
    REMARK_NAME_EDIT(12, "新客户备注名修改", 1200),
    @Deprecated
    LOOK_OVER_COMPANY_INFO(13, "查看公司信息", 1300),
    @Deprecated
    ASK_EMPLOY_INFO(14, "询问招聘类信息", 1400),
    @Deprecated
    REVENUE_TALK_MATERIAL(15, "创说会留资", 1500),
    @Deprecated
    RECRUIT_FAQ_VISIT(16, "增员专题类FAQ", 1350),
    LOOK_OVER_HEADWORD(17, "种草正文内仅查看词条", 1600),
    LOOK_OVER_CLAIM_CASE(18, "种草正文内的理赔案例", 1700),
    LOOK_OVER_PRODUCT_ARTICLE(19, "种草正文内的产品文章", 1800),
    EXPLOSION_VOTE(20, "参与种草正文内的投票", 1900),
    HEADWORD_FAQ_VISIT(21, "词条内的FAQ访问", 2100),
    LOOK_OVER_FAQ(22, "种草正文内的FAQ", 2200),

    FAQ_VISIT_NEW_ARTICLE(23,"FAQ详情页访问文章内",2300),
    FAQ_VISIT_NEW_COLUMN(24,"FAQ详情页访问文个人专栏",2400),
    FAQ_VISIT_NEW_ASK_ARTICLE(25,"FAQ详情页访问文章内,点击咨询",2500),
    FAQ_VISIT_NEW_ASK_COLUMN(26,"FAQ详情页访问文个人专栏,点击咨询",2600),

    FAQ_VISIT_DETAIL(27,"查看FAQ问答",2700),
    FAQ_VISIT_ASK(28,"查看FAQ问答，点击咨询",2800),
    FAQ_VISIT_SCAN(29,"查看FAQ问答,扫描二维码",2900),
    FAQ_VISIT_EXTRA_QUESTION(30,"查看FAQ问答,额外问答咨询",2899),

    WELFARE_INSURANCE(31,"赠险领取",3100),

    RISK_TEST(32,"风险评测重要线索",2001),

    VISIT_DATAGRAM_ARTICLE(33, "访问了资料包文章", 3300),

    ONE_BY_ONE(34,"1V1定制",3400),

    INSURE_ADVICE(35,"投保咨询",3500),

    INSURE_CALCULATE(36,"保费测算",3600),

    ARTICLE_PRIZE(37,"文内抽奖",3700)
    ;

    private Integer code;
    private String description;
    /**
     * 谁看过我展示优先级
     */
    private Integer order;

    VisitClueTypeEnum(Integer code, String description, Integer order) {
        this.code = code;
        this.description = description;
        this.order = order;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public Integer getOrder() {
        return order;
    }

    /**
     * 销售机会访问对应的线索code
     * @return
     */
    public static List<Integer> getSaleChanceCode(){
        return Lists.newArrayList(VisitClueTypeEnum.PRIVATE_FAQ_VISIT.getCode(),
                VisitClueTypeEnum.CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode(),
                VisitClueTypeEnum.MONTH_ACCUMULATE_VISIT.getCode(),
                VisitClueTypeEnum.PRODUCT_VISIT.getCode(),
                VisitClueTypeEnum.FAQ_VISIT_NEW_ARTICLE.getCode(),
                VisitClueTypeEnum.FAQ_VISIT_NEW_COLUMN.getCode(),
                VisitClueTypeEnum.FAQ_VISIT_NEW_ASK_COLUMN.getCode(),
                VisitClueTypeEnum.FAQ_VISIT_NEW_ASK_ARTICLE.getCode(),
                VisitClueTypeEnum.FAQ_VISIT_DETAIL.getCode(),
                VisitClueTypeEnum.FAQ_VISIT_SCAN.getCode(),
                VisitClueTypeEnum.FAQ_VISIT_ASK.getCode(),
                VisitClueTypeEnum.FAQ_VISIT_EXTRA_QUESTION.getCode(),
                VisitClueTypeEnum.ONE_BY_ONE.getCode(),
                VisitClueTypeEnum.INSURE_ADVICE.getCode(),
                VisitClueTypeEnum.INSURE_CALCULATE.getCode(),
                VisitClueTypeEnum.ARTICLE_PRIZE.getCode());
    }

    /**
     * 获取增员机会访问对应的线索id
     * @return
     */
    public static List<Integer> getRecruitChanceCode(){
        return Lists.newArrayList(VisitClueTypeEnum.RECRUIT_FAQ_VISIT.getCode(),
                VisitClueTypeEnum.ASK_EMPLOY_INFO.getCode(),
                VisitClueTypeEnum.LOOK_OVER_COMPANY_INFO.getCode(),
                VisitClueTypeEnum.REVENUE_TALK_MATERIAL.getCode());
    }

    /**
     * 根据代码返回线索访问类型枚举类
     *
     * @param code
     * @return
     */
    public static VisitClueTypeEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (VisitClueTypeEnum visitClueTypeEnum : VisitClueTypeEnum.values()) {
            if (Objects.equals(visitClueTypeEnum.getCode(), code)) {
                return visitClueTypeEnum;
            }
        }
        return null;
    }

    /**
     * 是否为延迟推送
     * @param code
     * @return
     */
    public static boolean isDelayPush(Integer code) {
        return Objects.equals(NORMAL_VISIT.code, code) || Objects.equals(FREQUENTLY_VISIT.code, code)
                || Objects.equals(DEPT_VISIT.code, code) || Objects.equals(PRODUCT_VISIT.code, code)
                || Objects.equals(MONTH_ACCUMULATE_VISIT.code, code);

    }

    /**
     * 根据线索code获取排序优先级
     * @param code
     * @return
     */
    public static Integer getOrder(Integer code) {
        for (VisitClueTypeEnum visitClueTypeEnum : VisitClueTypeEnum.values()) {
            if (Objects.equals(visitClueTypeEnum.code, code)) {
                return visitClueTypeEnum.order;
            }
        }
        return 0;
    }

    /**
     * 判断是否是代理人使用营销工具动态
     * @param type
     * @return
     */
    public static boolean isSellerGainSaleClueDynamicType(Integer type){
        List<Integer> list = Lists.newArrayList(DEPT_VISIT.code,MATERIAL_VISIT.code,PRIVATE_FAQ_VISIT.code,
                CLUE_ACTIVITY_SUBMIT_MATERIAL.code,MONTH_ACCUMULATE_VISIT.code,PRODUCT_VISIT.code,
                RECRUIT_FAQ_VISIT.code,LOOK_OVER_COMPANY_INFO.code,ASK_EMPLOY_INFO.code,REVENUE_TALK_MATERIAL.code,FAQ_VISIT_NEW_COLUMN.code
        ,FAQ_VISIT_NEW_ASK_ARTICLE.code,FAQ_VISIT_NEW_ARTICLE.code,FAQ_VISIT_NEW_ASK_COLUMN.code,FAQ_VISIT_DETAIL.code,FAQ_VISIT_ASK.code,FAQ_VISIT_SCAN.code,FAQ_VISIT_EXTRA_QUESTION.code
        ,WELFARE_INSURANCE.code,RISK_TEST.code,ONE_BY_ONE.code,INSURE_ADVICE.code,INSURE_CALCULATE.code,ARTICLE_PRIZE.code);
        return list.contains(type);
    }

    /**
     * 根据枚举名称获取
     * @param name
     * @return
     */
    public static VisitClueTypeEnum getByEnumName(String name) {
        for (VisitClueTypeEnum visitClueTypeEnum : VisitClueTypeEnum.values()) {
            if (StringUtils.equals(visitClueTypeEnum.toString(), name)) {
                return visitClueTypeEnum;
            }
        }
        return null;
    }

    /**
     * 谁看过我改版V3 FAQ类型
     * @return
     */
    public static List<Integer> getCustV3FAQClueTypes() {
        return Arrays.asList(PRIVATE_FAQ_VISIT.getCode(), RECRUIT_FAQ_VISIT.getCode(),
                HEADWORD_FAQ_VISIT.getCode(), LOOK_OVER_FAQ.getCode(), FAQ_VISIT_NEW_ARTICLE.getCode(),
                FAQ_VISIT_NEW_COLUMN.getCode(), FAQ_VISIT_NEW_ASK_ARTICLE.getCode(), FAQ_VISIT_NEW_ASK_COLUMN.getCode(),
                FAQ_VISIT_DETAIL.getCode(),FAQ_VISIT_ASK.getCode(),FAQ_VISIT_SCAN.getCode(),FAQ_VISIT_EXTRA_QUESTION.getCode());
    }

    /**
     * 谁看过我改版V3 风险评测
     * @return
     */
    public static List<Integer> getCustV3TestClueTypes() {
        return Arrays.asList(CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode());
    }

    /**
     * 谁看过我改版V3.1 投保意向 包括：查看问答，参与风险测评
     * @return
     */
    public static List<Integer> getCustV3InsuranceClueTypes() {
        return Arrays.asList(PRIVATE_FAQ_VISIT.getCode(), HEADWORD_FAQ_VISIT.getCode(), LOOK_OVER_FAQ.getCode(), FAQ_VISIT_NEW_ARTICLE.getCode(),
                FAQ_VISIT_NEW_COLUMN.getCode(), FAQ_VISIT_NEW_ASK_ARTICLE.getCode(), FAQ_VISIT_NEW_ASK_COLUMN.getCode(),
                FAQ_VISIT_DETAIL.getCode(),CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode());
    }

    /**
     * 谁看过我改版V3.1 增员意向
     * @return
     */
    public static List<Integer> getCustV3RecruitmentClueTypes() {
        return Arrays.asList(RECRUIT_FAQ_VISIT.getCode(),ASK_EMPLOY_INFO.getCode(),LOOK_OVER_COMPANY_INFO.getCode(),REVENUE_TALK_MATERIAL.getCode());
    }

    /**
     * 谁看过我改版V3 投票类型
     * @return
     */
    public static List<Integer> getCustV3VoteClueTypes() {
        return Arrays.asList(EXPLOSION_VOTE.getCode());
    }


    /**
     * 谁看过我改版V3 重要线索
     * @return
     */
    public static List<Integer> getCustV3ImportantClueTypes() {
        return Arrays.asList(FAQ_VISIT_SCAN.getCode(),FAQ_VISIT_ASK.code,FAQ_VISIT_EXTRA_QUESTION.code,WELFARE_INSURANCE.getCode(),RISK_TEST.getCode(),ONE_BY_ONE.getCode(),INSURE_ADVICE.getCode()
        ,VisitClueTypeEnum.INSURE_CALCULATE.getCode(),VisitClueTypeEnum.ARTICLE_PRIZE.getCode());
    }

    /**
     * 目前有效的线索类型
     * @return
     */
    public static List<Integer> getValidClues() {
        return Arrays.asList(PRIVATE_FAQ_VISIT.getCode(), CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode(),
                RECRUIT_FAQ_VISIT.getCode(), LOOK_OVER_HEADWORD.getCode(), LOOK_OVER_CLAIM_CASE.getCode(),
                LOOK_OVER_PRODUCT_ARTICLE.getCode(), EXPLOSION_VOTE.getCode(), HEADWORD_FAQ_VISIT.getCode(), LOOK_OVER_FAQ.getCode(),
                FAQ_VISIT_NEW_ARTICLE.getCode(), FAQ_VISIT_NEW_COLUMN.getCode(),FAQ_VISIT_NEW_ASK_ARTICLE.getCode(), FAQ_VISIT_NEW_ASK_COLUMN.getCode(),
                FAQ_VISIT_ASK.getCode(),FAQ_VISIT_DETAIL.getCode(),FAQ_VISIT_SCAN.getCode(),FAQ_VISIT_EXTRA_QUESTION.getCode(),WELFARE_INSURANCE.getCode(),
                RISK_TEST.getCode(), VISIT_DATAGRAM_ARTICLE.getCode(),ONE_BY_ONE.getCode(),INSURE_ADVICE.getCode(),INSURE_CALCULATE.getCode(),ARTICLE_PRIZE.getCode());
    }

    /**
     * 客户意向度线索
     * @return
     */
    public static List<Integer> getSellerCustomerIntentionClues() {
        return Arrays.asList(CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode(), FAQ_VISIT_DETAIL.getCode(), FAQ_VISIT_ASK.getCode(),
                FAQ_VISIT_SCAN.getCode(), FAQ_VISIT_EXTRA_QUESTION.getCode(), WELFARE_INSURANCE.getCode(), RISK_TEST.getCode());
    }

    /**
     * 60天开单计划任务 重要线索
     * @return
     */
    public static List<Integer> getBillingPlanImportantClueTypes() {
        return Arrays.asList(FAQ_VISIT_SCAN.getCode(),WELFARE_INSURANCE.getCode(),RISK_TEST.getCode(),ONE_BY_ONE.getCode(),INSURE_ADVICE.getCode(),INSURE_CALCULATE.getCode(),ARTICLE_PRIZE.getCode());
    }

    /**
     * 客户详情页的faq问答类型的线索列表
     * @return
     */
    public static List<Integer> getCustInfoFaqType() {
        return Arrays.asList(FAQ_VISIT_DETAIL.getCode(), FAQ_VISIT_ASK.getCode(), FAQ_VISIT_EXTRA_QUESTION.getCode());
    }

    /**
     * 客户详情页 参与评测
     * @return
     */
    public static List<Integer> getCustInfoTestType() {
        return Arrays.asList(CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode(), RISK_TEST.getCode());
    }

    /**
     * 目前有效的线索类型
     * @return
     */
    public static List<Integer> getCustInfoDisplayClues() {
        return Arrays.asList(PRIVATE_FAQ_VISIT.getCode(), CLUE_ACTIVITY_SUBMIT_MATERIAL.getCode(),
                RECRUIT_FAQ_VISIT.getCode(), LOOK_OVER_HEADWORD.getCode(), LOOK_OVER_CLAIM_CASE.getCode(),
                LOOK_OVER_PRODUCT_ARTICLE.getCode(), EXPLOSION_VOTE.getCode(), HEADWORD_FAQ_VISIT.getCode(), LOOK_OVER_FAQ.getCode(),
                FAQ_VISIT_NEW_ARTICLE.getCode(), FAQ_VISIT_NEW_COLUMN.getCode(),FAQ_VISIT_NEW_ASK_ARTICLE.getCode(), FAQ_VISIT_NEW_ASK_COLUMN.getCode(),
                FAQ_VISIT_ASK.getCode(),FAQ_VISIT_DETAIL.getCode(),FAQ_VISIT_SCAN.getCode(),FAQ_VISIT_EXTRA_QUESTION.getCode(),WELFARE_INSURANCE.getCode(),
                RISK_TEST.getCode(), ONE_BY_ONE.getCode(),INSURE_ADVICE.getCode(),INSURE_CALCULATE.getCode(),ARTICLE_PRIZE.getCode());
    }
}
