package cn.com.duiba.kjy.api.enums.crm.contract;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 盖章类型
 * @date 2021/3/16 19:51
 */
public enum CrmContractSignTypeEnum {

    /**
     * 盖章类型 1：合同章 2：法人章 3:其他
     */
    CONTRACT_CHAPTER(1, "合同章"),
    ARTIFICIAL_PERSON_CHAPTER(2,"公章+法人章"),
    OTHER_CHAPTER(3,"其他"),
    ;

    private Integer code;

    private String desc;

    CrmContractSignTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmContractSignTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmContractSignTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static CrmContractSignTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
