package cn.com.duiba.kjy.api.enums.honorary;

import cn.com.duiba.kjy.api.enums.animation.AnimationBizTypeEnum;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/3/17 2:39 PM
 */
public enum HonoraryTypeEnum {

    POSTER(1, "荣誉相册（海报）"),
    ANIMATION(2, "荣誉相册（音乐相册）"),
    VIDEO(3, "荣誉相册（视频相册）")
    ;

    private Integer type;

    private String desc;

    HonoraryTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, HonoraryTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(HonoraryTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static HonoraryTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 根据动画工具业务类型，获取邀请函类型
     * @param bizType 动画工具业务类型
     * @return 是否有效
     */
    public static HonoraryTypeEnum getByAnimationBizType(Integer bizType) {
        AnimationBizTypeEnum bizTypeEnum = AnimationBizTypeEnum.getByType(bizType);
        if (bizTypeEnum == null) {
            return null;
        }
        if (bizTypeEnum.equals(AnimationBizTypeEnum.HONORARY_ALBUM_POSTER)) {
            return POSTER;
        }
        if (bizTypeEnum.equals(AnimationBizTypeEnum.HONORARY_ALBUM_ANIMATION)) {
            return ANIMATION;
        }

        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
