package cn.com.duiba.kjy.api.dto.lottery.detail;

import cn.com.duiba.kjy.api.dto.lottery.PrizeDto;
import cn.com.duiba.kjy.api.dto.lottery.ThirdPrizeExtDto;
import cn.com.duiba.kjy.api.util.ErrorCode;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author lizhi
 * @date 2019/10/23 2:57 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PrizeDetailDto extends PrizeDto {

    private static final long serialVersionUID = -6737045139976125477L;

    /**
     * 中奖日期
     */
    private String winningDate;

    /**
     * 有效期
     */
    private Date prizeEndTime;

    /**
     * 兑吧奖项详情
     */
    private ThirdPrizeExtDto thirdPrizeExtDto;

    /**
     * 错误码
     */
    private ErrorCode errorCode;

    /**
     * 原中奖ID
     */
    private Long originalPrizeId;

    public static PrizeDetailDto getErrorPrizeDetailDto(ErrorCode errorCode, Long prizeId) {
        PrizeDetailDto dto = new PrizeDetailDto();
        dto.setErrorCode(errorCode);
        dto.setId(prizeId);
        return dto;
    }
}

