package cn.com.duiba.kjy.api.params.lottery;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lizhi
 * @date 2019/10/23 3:05 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LotteryWinningRecordParams extends PageQuery {

    private static final long serialVersionUID = -87258617652100570L;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 抽奖ID
     */
    private Long lotteryId;

    /**
     * 活动ID，对应tb_content.id
     */
    private Long activityId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long sellerUserId;

    /**
     * 活动配置ID，对应tb_seller_activity_conf.id
     */
    private Long activityConfId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 中奖日期
     */
    private String winningDate;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 奖品类型：1-谢谢参与,2-再来一次,3-销售员定制,4-链接优惠券,5-实物
     * @see cn.com.duiba.kjy.api.enums.lottery.PrizeTypeEnum
     */
    private Integer prizeType;

    /**
     * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer deleted;

    /**
     * false-不管有效期，true-只查有效期为空或未过期的
     */
    private Boolean notExpired;
}
