package cn.com.duiba.kjy.api.params.seller;

import cn.com.duiba.wolf.utils.DateUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author 吴文哲
 * @date 2019-09-26 18:36
 **/
@Data
public class SellerCustomerStatisticsParam implements Serializable {

    private static final long serialVersionUID = -2453557700058518182L;

    public String getStatisticTime() {
        if(Objects.isNull(this.now)){
            return null;
        }
        //前天
        Date theDayBeforeYesterday = DateUtils.daysAddOrSub(this.now, -2);
        return String.valueOf(DateUtils.getDayNumber(theDayBeforeYesterday));
    }

    /**
     * 统计时间 yyyyMMdd
     */
    private String  statisticTime;



    /**
     * 当前时间
     */
    private Date now;

    /**
     * 代理人Id
     */
    private Long sellerId;

    /**
     * 客户ID列表
     */
    private List<Long> custUserIds;






}
