package cn.com.duiba.kjy.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.tag.ItemTagExtDto;
import cn.com.duiba.kjy.api.dto.tag.ItemTagDto;
import cn.com.duiba.kjy.api.enums.tag.TagItemTypeEnum;

import java.util.List;
import java.util.Map;

/**
 * item和标签关联关系service
 * @author zhanghuifeng
 * date 2019-04-11-15:11
 */
@AdvancedFeignClient
public interface RemoteItemTagService {

    /**
     * 根据标签集合获取存在的标签集合
     * @param tagIds
     * @return
     */
    List<Long> findExitTagIdsByTagIds(List<Long> tagIds);

    /**
     * 默认 type = content
     * @param itemIdList
     * @return
     */
    @Deprecated
    Map<Long/*contentId*/, Map<Integer/*level*/, List<ItemTagExtDto>>> findTagByItemIds(List<Long> itemIdList);

    /**
     * 根据itemIds查询标签
     * @param itemIdList
     * @param type
     * @return
     */
    Map<Long, Map<Integer, List<ItemTagExtDto>>> findTagByItemIdsAndType(List<Long> itemIdList, TagItemTypeEnum type);

    /**
     * 根据itemId集合获取
     * @param itemIds
     * @param itemType @see TagItemTypeEnum
     * @return
     */
    List<ItemTagDto> findByItemIds(List<Long> itemIds, Integer itemType);

    int updateItemTags(Long itemId, List<Long> tagIds, TagItemTypeEnum type);
}
