package cn.com.duiba.kjy.api.dto.seller.weekly;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author wangbinbin
 * @create 2019-08-13 14:57
 * @descript
 */
@Data
public class SellerWeeklyPublicationDto implements Serializable {

    private static final long serialVersionUID = 7946901423897775195L;
    /**
     * week_num计算开始时间 2019-08-05 00:00:00
     */
    private static final long START_TIMESTAMP = 1564934400000L;

    /**
     * 周报id
     */
    private Long id;
    /**
     * 代理人id
     */
    private Long sellerId;
    /**
     * 周开始时间
     */
    private Date startDate;
    /**
     * 周结束时间
     */
    private Date endDate;
    /**
     * 第几周
     */
    private Integer weekNum;
    /**
     * 周总分享数
     */
    private Integer totalShareNum;
    /**
     * 周总分享详情
     */
    private List<TotalShareInfo> totalShareInfos;
    /**
     * 周每日分享数
     */
    private List<Integer> dayShareNum;
    /**
     * 周总获客数
     */
    private Integer totalVisitorNum;
    /**
     * 周总访问次数
     */
    private Integer totalVisitNum;
    /**
     * 周每日访客数
     */
    private List<Integer> dayVisitNum;
    /**
     * 周获客详情
     */
    private List<TotalVisitorInfo> totalVisitorInfos;
    /**
     * 获新客户数
     */
    private Integer freshVisitorNum;
    /**
     * 新客户详情
     */
    private List<FreshVisitorInfo> freshVisitorInfos;
    /**
     * 关键线索数
     */
    private Integer keyCluesNum;
    /**
     * 关键线索详情
     */
    private List<KeyCluesInfo> keyCluesInfos;
    /**
     * 击败百分比
     */
    private Integer beatPercentage;
    /**
     * 关键词
     */
    private String summaryWord;
    /**
     * 周报生成时间
     */
    private Date gmtCreate;
    /**
     * 周报修改时间
     */
    private Date gmtModified;


    @Data
    public static class TotalShareInfo implements Serializable {

        private static final long serialVersionUID = 8173409333808786936L;

        /**
         * 内容id
         */
        private Long contentId;
        /**
         * 代理人文章id
         */
        private Long scId;
        /**
         * 内容类型
         * @see cn.com.duiba.kjy.api.constant.ContentTypeEnum
         */
        private String contentType;
        /**
         * 平均阅读时间
         */
        private Integer averageReadDuration = 0;
        /**
         * 内容线索数
         */
        private Integer clueNum = 0;
        /**
         * 内容访问人数
         */
        private Integer visitorNum;
        /**
         * @Deprecated 不再存储visitorIds
         * 内容访客id列表
         */
        private List<Long> visitorIds;
        /**
         * 内容分享次数
         */
        private Integer shareTimes;

    }

    @Data
    public static class TotalVisitorInfo implements Serializable {

        private static final long serialVersionUID = 3293832723666895221L;

        /**
         * 用户id
         */
        private Long userId;
        /**
         * 关注度
         */
        private Integer attentionNum;
        /**
         * 周第一次访问时间
         */
        private Date weeklyFirstVisitTime;
    }

    @Data
    public static class FreshVisitorInfo implements Serializable {

        private static final long serialVersionUID = -2040603472276127437L;

        /**
         * 用户id
         */
        private Long userId;
        /**
         * 首次访问时间
         */
        private Date firstVisitTime;
    }

    @Data
    public static class KeyCluesInfo implements Serializable {

        private static final long serialVersionUID = -8034604741021684170L;

        /**
         * 线索类型
         * @see cn.com.duiba.kjy.api.enums.seller.ClueTypeEnum
         */
        private String type;
        /**
         * 提供素材的用户id列表  内容id = [用户id]
         */
        private Map<Long, List<Long>> contentVisitors;
    }


    /**
     * 获取当前时间所在周数 距离START_TIMESTAMP
     * @return
     */
    public static int buildWeekNum() {
        return Math.toIntExact((System.currentTimeMillis() - START_TIMESTAMP) / (1000 * 60 * 60 * 24 * 7L));
    }

    public static int buildWeekNum(Long timestamp) {
        return Math.toIntExact((timestamp - START_TIMESTAMP) / (1000 * 60 * 60 * 24 * 7L));
    }

    public static void main(String[] args) {
        System.out.println(buildWeekNum());
    }

}
