package cn.com.duiba.kjy.api.enums.privatechat;

import java.util.Objects;

/**
 * @auther: linjianhui
 * @date: 2019-08-22 14:33
 * @description: formID是否使用
 */
public enum HasUsedEnum {

    /**
     * 是否使用 0：未使用 1：已使用
     */
    UN_USED(0, "未使用"),
    USED(1, "已使用"),
    ;

    private Integer code;

    private String desc;

    HasUsedEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static HasUsedEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (HasUsedEnum hasUsedEnum : values()) {
            if (Objects.equals(hasUsedEnum.getCode(), code)) {
                return hasUsedEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
