package cn.com.duiba.kjy.api.enums.seller;

import java.util.Arrays;
import java.util.List;

/**
 * 销售员来源定义
 * @author zhanghuifeng
 * date 2019-06-25-16:27
 */
public enum SellerFromEnum {

    /**
     * 销售来源场景
     */
    NORMAL("0", "一般途径"),
    POSTER_INVITE("1", "海报邀请(普通邀请)"),
    CARD("2", "内容页换名片邀请（普通邀请）"),
    SITE_SALE_QR("3", "会销扫码（会销邀请）"),
    OUR_INSIDE_RECOMMEND("4", "公司内部销售推荐（只用作绩效记录，不做其它业务用途）"),
    WEEKLY_PUBLICATION("5", "周报中关注客集集"),
    VISITOR_PAYMENT("6", "访客转化为付费用户"),
    NOVICE_TASK("7", "新手任务邀请"),
    NATIONAL_DAY_ACTIVITY("8", "国庆节活动扫码关注客集集"),
    SINGLE_FESTIVAL("9", "双十一活动扫码关注客集集"),
    PRIVATE_CHAT("15", "私信页面-聊天界面"),
    ACTIVATE_CODE("45", "激活码"),
    WX_MP_BASE_AUTH("46", "小程序授权"),
    WX_FISSION_MP_BSE_AUTH("47", "微信裂变小程序授权"),

    ;
    private String from;
    private String desc;

    SellerFromEnum(String from, String desc) {
        this.from = from;
        this.desc = desc;
    }

    /**
     * 获取所有需要发送绑定上下级关系客服消息类型
     */
    public static List<String> getNeedSendMsgTypes() {
        return Arrays.asList(POSTER_INVITE.getFrom(),
                CARD.getFrom(),
                SITE_SALE_QR.getFrom(),
                PRIVATE_CHAT.getFrom());
    }

    /**
     * 获取所有,上级可以非付费会员邀请类型
     */
    public static List<String> getOrdinaryUserDistributionTypes() {
        return Arrays.asList(VISITOR_PAYMENT.getFrom(),
                PRIVATE_CHAT.getFrom(),
                CARD.getFrom());
    }

    /**
     * 根据from处理获取对应枚举
     * @param from
     * @return
     */
    public static SellerFromEnum getByfrom(String from) {
        for (SellerFromEnum enumVal : SellerFromEnum.values()) {
            if (enumVal.getFrom().equals(from)) {
                return enumVal;
            }
        }
        return null;
    }

    public String getFrom() {
        return from;
    }

    public String getDesc() {
        return desc;
    }
}
