package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.ContentConfitDto;
import cn.com.duiba.kjy.api.enums.ContentConfigTypeEnum;

/**
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年10月21日 11:50
 **/
@AdvancedFeignClient
public interface RemoteContentConfigService {

    /**
     * 根据文章id查询
     * 默认早报
     * @param contentId
     * @return
     */
    @Deprecated
    ContentConfitDto findByContentId(Long contentId);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    ContentConfitDto findById(Long id);


    ContentConfitDto findByContentIdAndType(Long contentId, ContentConfigTypeEnum type);

    /**
     * 新增或修改，contentId必传
     * @param contentConfitDto
     * @return
     */
    Boolean insertOrUpdate(ContentConfitDto contentConfitDto);
}
