package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.MarketAreaItemCompanyDto;
import cn.com.duiba.kjy.api.dto.MarketAreaItemDto;
import cn.com.duiba.kjy.api.params.MarketAreaItemParam;
import cn.com.duiba.kjy.api.params.MarketAreaSearchParam;

import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteMarketAreaService {

    Boolean insert(MarketAreaItemParam dto);

    Boolean update(MarketAreaItemParam dto);

    Boolean updateState(Long id, Integer state, Long companyId);

    Boolean delete(Long id, Long companyId);

    MarketAreaItemDto findById(Long id);

    List<MarketAreaItemDto> selectList(MarketAreaSearchParam param);

    Long selectCount(MarketAreaSearchParam param);

    /**
     * 该接口为老版接口，没有用到，下次代码整理删除
     * @param companyId
     * @return
     */
    @Deprecated
    List<MarketAreaItemCompanyDto> findByCompany(Long companyId);

    List<MarketAreaItemCompanyDto> findPageByCompany(Long companyId, Integer pageIndex, Integer pageSize);

    /**
     * 查询
     * @param ids
     * @return
     */
    Map<Long, MarketAreaItemDto> findByIds(List<Long> ids);

    /**
     * 交换位置
     * @param id
     * @param anotherId
     * @return
     */
    Boolean exchangeLocation(Long id ,Long anotherId);

}
