package cn.com.duiba.kjy.api.remoteservice.greeting;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.greeting.SellerGreetingCardConfDto;
import cn.com.duiba.kjy.api.params.greeting.SellerGreetingCardConfQueryParam;

import java.util.List;

/**
 * 远程代理人节日贺卡配置服务
 * @author 刘超
 * @date 2019/12/18 13:48
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteSellerGreetingCardConfService {

    /**
     * 分页查询
     * @param queryParam 分页查询参数
     * @return 代理人贺卡配置信息集合
     */
    List<SellerGreetingCardConfDto> findPageList(SellerGreetingCardConfQueryParam queryParam);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 代理人贺卡配置信息
     */
    SellerGreetingCardConfDto findById(Long id);

    /**
     * 保存节日贺卡配置
     * @param dto 代理人贺卡配置信息
     * @return 主键，为0，说明新增失败
     */
    Long save(SellerGreetingCardConfDto dto);

    /**
     * 根据id修改，只允许更改代理人署名、祝福语、祝福图片、分享标题
     * @param dto 代理人贺卡配置信息
     * @return 是否成功
     */
    boolean updateById(SellerGreetingCardConfDto dto);

    /**
     * 统计当天代理人发起数量，左闭右开
     * @param sellerId 代理人id
     * @return 当天发起的数量
     */
    int countDailyBySeller(Long sellerId);
}
