package cn.com.duiba.kjy.api.dto.lottery.detail;

import cn.com.duiba.kjy.api.dto.lottery.LotteryPrizeDto;
import cn.com.duiba.kjy.api.dto.lottery.PrizeDto;
import cn.com.duiba.kjy.api.util.ErrorCode;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lizhi
 * @date 2019/10/23 2:54 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LotteryPrizeDetailDto extends LotteryPrizeDto {

    private static final long serialVersionUID = -8331103537307285326L;
    /**
     * 奖品详情
     */
    private PrizeDto prizeDto;

    /**
     * 销售员自定义奖品ID
     */
    private Long activityCustomPrizeDtoId;

    /**
     * 用于记录根据出奖规则出奖时的错误原因
     */
    private ErrorCode errorCode;

    public static LotteryPrizeDetailDto getErrorLotteryPrizeDetailDto(ErrorCode errorCode) {
        LotteryPrizeDetailDto dto = new LotteryPrizeDetailDto();
        dto.setErrorCode(errorCode);
        return dto;
    }
}
