package cn.com.duiba.kjy.api.enums.company;

/**
 * 公司状态枚举 1:待发布 2:已发布 3:已删除
 * @author 吴文哲
 * @date 2019-12-28 15:15
 **/
public enum CompanyNewsStateEnum {

    TO_BE_RELEASED(1, "待发布"),
    PUBLISHED(2, "已发布"),
    ;

    private Integer type;

    private String desc;

    CompanyNewsStateEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static CompanyNewsStateEnum getByType(Integer type) {
        for (CompanyNewsStateEnum enumVal : CompanyNewsStateEnum.values()) {
            if (enumVal.getType().equals(type)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
