package cn.com.duiba.kjy.api.enums.lottery;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/10/23 3:09 PM
 */
public enum PrizeSourceEnum {

    KJJ_COUPON_STOCK(1, "客集集优惠券库"),
    KE_JI_JI(2, "客集集"),
    SELLER_CUSTOM(3, "销售员定制"),
    ;

    private Integer source;

    private String desc;

    PrizeSourceEnum(Integer source, String desc) {
        this.source = source;
        this.desc = desc;
    }

    private static final Map<Integer, PrizeSourceEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PrizeSourceEnum sourceEnum : values()){
            ENUM_MAP.put(sourceEnum.getSource(), sourceEnum);
        }
    }

    public static PrizeSourceEnum getBySource(Integer source) {
        if (source == null) {
            return null;
        }
        return ENUM_MAP.get(source);
    }

    /**
     * 来源是否是第三方
     * @return true-是，false-否
     */
    public boolean isThird() {
        return this == KJJ_COUPON_STOCK;
    }

    public Integer getSource() {
        return source;
    }

    public String getDesc() {
        return desc;
    }
}
