package cn.com.duiba.kjy.api.params.redpacket;

import lombok.Data;

import java.io.Serializable;

/**
 * 创建红包参数
 * @author lizhi
 * @date 2020/1/7 5:42 PM
 */
@Data
public class RedPacketCreateParam implements Serializable {

    private static final long serialVersionUID = 8453437523802371890L;

    /**
     * 红包对应的业务id
     */
    private Long redPacketBizId;

    /**
     * 红包对应的业务类型
     * @see cn.com.duiba.kjy.api.enums.redpacket.RedPacketBizTypeEnum
     */
    private Integer redPacketBizType;

    /**
     * 祝福语
     */
    private String blessWord;

    /**
     * 单个红包金额
     */
    private Integer singleAmount;

    /**
     * 总红包个数
     */
    private Integer totalNum;

    /**
     * 剩余个数
     */
    private Integer surplusNum;

    /**
     * 总金额
     */
    private Integer totalAmount;

    /**
     * 优惠金额
     */
    private Integer promotionAmount;

    /**
     * 支付金额
     */
    private Integer payAmount;

    /**
     * 剩余金额
     */
    private Integer surplusAmount;

    /**
     * 已领取金额
     */
    private Integer receivedAmount;

    /**
     * 优惠id，对应tb_seller_promotion.id
     */
    private Long promotionId;

    /**
     * 兑吧appId
     */
    private Long appId;

    /**
     * 用户真实Ip
     */
    private String clientIp;

    /**
     * 用户openId
     */
    private String openId;
}
